<?php
session_start();
require_once '../config/db.php';
require_once '../auth/auth.php';

if (!isset($_SESSION['user_id'])) {
    die('Not authorized');
}

if (!isset($_GET['refund_id'])) {
    die('Refund ID is required');
}

$refund_id = $_GET['refund_id'];

// Get store information
$stmt = $pdo->prepare("SELECT setting_key, setting_value, setting_binary FROM store_settings WHERE setting_group = 'store_info'");
$stmt->execute();
$settings = [];
$logoData = null;
$logoName = '';
while ($row = $stmt->fetch()) {
    $settings[$row['setting_key']] = $row['setting_value'];
    if ($row['setting_key'] === 'store_logo') {
        $logoData = $row['setting_binary'];
        $logoName = $row['setting_value'];
    }
}

// Debug output to verify store settings
error_log("Store Settings: " . print_r($settings, true));

// Get refund details
$stmt = $pdo->prepare("
    SELECT 
        r.*,
        s.invoice_number,
        s.created_at as sale_date,
        u.username as processed_by,
        c.name as customer_name
    FROM refunds r
    JOIN sales s ON r.sale_id = s.id
    JOIN users u ON r.processed_by = u.id
    LEFT JOIN customers c ON s.customer_id = c.id
    WHERE r.id = ?
");
$stmt->execute([$refund_id]);
$refund = $stmt->fetch();

if (!$refund) {
    die('Refund not found');
}

// Get refund items
$stmt = $pdo->prepare("
    SELECT 
        ri.*,
        p.name as product_name,
        ri.serial_numbers
    FROM refund_items ri
    JOIN products p ON ri.product_id = p.id
    WHERE ri.refund_id = ?
");
$stmt->execute([$refund_id]);
$items = $stmt->fetchAll();

// Get currency from settings
$currency = $settings['currency'] ?? 'Ksh';
$website = $settings['website'] ?? '';

// Store info for header
$store_header = [
    'store_name' => $settings['store_name'] ?? '',
    'store_address' => $settings['store_address'] ?? '',
    'store_phone' => $settings['store_phone'] ?? '',
    'store_email' => $settings['store_email'] ?? '',
    'website' => $settings['website'] ?? ''
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Refund Receipt <?php echo $refund['refund_number']; ?></title>
    <style>
        body, .receipt {
            width: 80mm !important;
            max-width: 80mm !important;
            margin: 0 auto;
            font-family: 'Segoe UI', Arial, 'Helvetica Neue', sans-serif;
            font-size: 13px;
            color: #000;
            background: #fff;
        }
        .receipt {
            padding: 0;
        }
        .receipt-header, .receipt-details, .receipt-items, .receipt-footer {
            width: 100%;
            margin-bottom: 8px;
        }
        .receipt-details {
            text-align: left;
            margin-bottom: 12px;
        }
        .receipt-details .row {
            display: flex;
            justify-content: flex-start;
            margin-bottom: 2px;
        }
        .receipt-details .label {
            min-width: 70px;
            font-weight: 600;
            color: #000;
        }
        .receipt-details .value {
            flex: 1;
            color: #000;
        }
        .receipt-title {
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            margin: 15px 0;
            padding: 10px 0;
            border-bottom: 2px solid #000;
            color: #000;
        }
        .refund-details {
            margin: 20px 0;
            text-align: center;
            padding: 15px 0;
        }
        .refund-details div {
            margin: 5px 0;
            font-size: 13px;
            white-space: nowrap;
        }
        .refund-details .label {
            font-weight: bold;
            display: inline-block;
            width: 100px;
            text-align: right;
            margin-right: 5px;
        }
        .refund-details .value {
            display: inline-block;
            text-align: left;
        }
        .items {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .items th, .items td {
            padding: 3px;
            text-align: left;
            border-bottom: 1px solid #ddd;
            font-size: 12px;
            color: #000;
        }
        .items th {
            font-weight: bold;
        }
        .total {
            text-align: right;
            font-weight: bold;
            margin-top: 15px;
            font-size: 13px;
            color: #000;
        }
        .separator {
            border-top: 1px solid #ddd;
            margin: 20px 0;
        }
        .thank-you {
            text-align: center;
            font-size: 14px;
            margin: 15px 0;
            font-style: italic;
        }
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: 12px;
            color: #000;
        }
        .qr-code {
            text-align: center;
            margin: 20px 0;
        }
        .qr-code img {
            max-width: 150px;
            height: auto;
        }
        .credit {
            text-align: center;
            margin-top: 10px;
            font-size: 12px;
            color: #000;
            border-top: 1px solid #ddd;
            padding-top: 10px;
            font-weight: bold;
        }
        .store-logo, .store-name, .store-details {
            text-align: center;
            margin-left: auto;
            margin-right: auto;
        }
        .store-logo img {
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        @media print {
            body, .receipt {
                width: 80mm !important;
                max-width: 80mm !important;
            }
        }
        .header {
            text-align: center;
            margin-bottom: 5px;
            padding-bottom: 3px;
            border-bottom: 1px dashed #000;
        }
        .store-logo {
            max-width: 60mm;
            max-height: 30mm;
            margin: 5px auto;
            display: block;
        }
        .store-name {
            font-size: 20px;
            font-weight: 800;
            margin: 10px 0;
            color: #000;
        }
        .store-details {
            font-size: 13px;
            margin: 5px 0;
            padding-bottom: 10px;
            border-bottom: 1px solid #000;
            color: #000;
        }
        .store-details p {
            margin: 3px 0;
            line-height: 1.4;
        }
    </style>
</head>
<body>
    <div class="receipt">
        <div class="header">
            <?php if ($logoData): ?>
                <?php
                $mimeType = 'image/jpeg'; // Default to JPEG
                if (strpos($logoName, '.png') !== false) {
                    $mimeType = 'image/png';
                } elseif (strpos($logoName, '.gif') !== false) {
                    $mimeType = 'image/gif';
                }
                ?>
                <img src="data:<?php echo $mimeType; ?>;base64,<?php echo base64_encode($logoData); ?>" alt="Store Logo" class="store-logo">
            <?php endif; ?>
            <div class="store-name"><?php echo htmlspecialchars($store_header['store_name']); ?></div>
            <div class="store-details">
                <p><?php echo htmlspecialchars($store_header['store_address']); ?></p>
                <p>Phone: <?php echo htmlspecialchars($store_header['store_phone']); ?></p>
                <p>Email: <?php echo htmlspecialchars($store_header['store_email']); ?></p>
                <?php if (!empty($store_header['website'])): ?>
                    <p>Web: <?php echo htmlspecialchars($store_header['website']); ?></p>
                <?php endif; ?>
            </div>
        </div>
        <div style="height:2px; background:#000; width:100%; margin: 6px 0 0 0;"></div>
        <div class="receipt-title" style="margin-top:0;">Refund Receipt</div>

        <div class="receipt-details">
            <div class="row"><span class="label">Refund #:</span> <span class="value"><?php echo $refund_id; ?></span></div>
            <div class="row"><span class="label">Sale #:</span> <span class="value"><?php echo htmlspecialchars($refund['invoice_number']); ?></span></div>
            <div class="row"><span class="label">Date:</span> <span class="value"><?php echo date('Y-m-d H:i:s', strtotime($refund['created_at'])); ?></span></div>
            <div class="row"><span class="label">Customer:</span> <span class="value"><?php echo htmlspecialchars($refund['customer_name'] ?? 'Walk-in Customer'); ?></span></div>
            <div class="row"><span class="label">Processed by:</span> <span class="value"><?php echo htmlspecialchars($refund['processed_by']); ?></span></div>
            <div class="row"><span class="label">Reason:</span> <span class="value"><?php echo htmlspecialchars($refund['reason']); ?></span></div>
        </div>

        <table class="items">
            <thead>
                <tr>
                    <th>Item</th>
                    <th>Qty</th>
                    <th>Price</th>
                    <th>Total</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($items as $item): ?>
                <tr>
                    <td>
                        <?php echo htmlspecialchars($item['product_name']); ?>
                        <?php if (!empty($item['serial_numbers'])): ?>
                            <br><small>SN: <?php echo htmlspecialchars($item['serial_numbers']); ?></small>
                        <?php endif; ?>
                    </td>
                    <td><?php echo $item['quantity']; ?></td>
                    <td><?php echo number_format($item['unit_price'], 2); ?></td>
                    <td><?php echo number_format(($item['quantity'] * $item['unit_price']) - ($item['discount'] ?? 0), 2); ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="total">
            Total Refund: <?php echo number_format($refund['amount'], 2); ?>
        </div>

        <div class="separator"></div>

        <div class="thank-you">
            Thank you for doing business with <?php echo htmlspecialchars($store_header['store_name'] ?? 'our store'); ?>
        </div>

        <div class="qr-code">
            <?php
            $qrData = json_encode([
                'refund_id' => $refund_id,
                'invoice' => $refund['invoice_number'],
                'amount' => $refund['amount'],
                'date' => $refund['created_at'],
                'store' => $store_header['store_name'] ?? 'Store Name'
            ]);
            $qrUrl = 'https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=' . urlencode($qrData);
            ?>
            <img src="<?php echo $qrUrl; ?>" alt="Refund QR Code">
        </div>

        <div class="footer">
            <?php echo date('Y-m-d H:i:s'); ?>
        </div>

        <div class="credit">
            Designed and developed by Vico Technologies
        </div>
    </div>

    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html> 